/*
 * Decompiled with CFR 0.152.
 */
package me.alphamode.star.world.fluids;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2386;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4538;

public abstract class DirectionalFluid
extends class_3609 {
    protected final class_2350 flowDirection;

    public DirectionalFluid(class_2350 flowDirection) {
        this.flowDirection = flowDirection;
    }

    public class_2350 getFlowDirection() {
        return this.flowDirection;
    }

    public class_243 method_15782(class_1922 world, class_2338 pos, class_3610 state) {
        double d = 0.0;
        double e = 0.0;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            mutable.method_25505((class_2382)pos, direction);
            class_3610 fluidState = world.method_8316((class_2338)mutable);
            if (!this.method_15748(fluidState)) continue;
            float f = fluidState.method_20785();
            float g = 0.0f;
            if (f == 0.0f) {
                class_3610 fluidState2 = world.method_8316((class_2338)mutable.method_10098(this.flowDirection));
                if (this.method_15748(fluidState2)) {
                    float f2;
                    f = fluidState2.method_20785();
                    if (f2 > 0.0f) {
                        g = state.method_20785() - (f - 0.8888889f);
                    }
                }
            } else if (f > 0.0f) {
                g = state.method_20785() - f;
            }
            if (g == 0.0f) continue;
            d += (double)((float)direction.method_10148() * g);
            e += (double)((float)direction.method_10165() * g);
        }
        class_243 vec3d = new class_243(d, 0.0, e);
        if (((Boolean)state.method_11654((class_2769)field_15902)).booleanValue()) {
            for (class_2350 direction2 : class_2350.class_2353.field_11062) {
                mutable.method_25505((class_2382)pos, direction2);
                if (!this.method_15749(world, (class_2338)mutable, direction2) && !this.method_15749(world, (class_2338)mutable.method_10098(this.flowDirection.method_10153()), direction2)) continue;
                vec3d = vec3d.method_1029().method_1031(0.0, -6.0, 0.0);
                break;
            }
        }
        return vec3d.method_1029();
    }

    protected boolean method_15749(class_1922 world, class_2338 pos, class_2350 direction) {
        class_2680 blockState = world.method_8320(pos);
        class_3610 fluidState = world.method_8316(pos);
        if (fluidState.method_15772().method_15780((class_3611)this)) {
            return false;
        }
        if (direction == this.flowDirection.method_10153()) {
            return true;
        }
        return !(blockState.method_26204() instanceof class_2386) && blockState.method_26206(world, pos, direction);
    }

    protected void method_15725(class_1937 world, class_2338 fluidPos, class_3610 state) {
        if (state.method_15769()) {
            return;
        }
        class_2680 blockState = world.method_8320(fluidPos);
        class_2338 blockPos = fluidPos.method_10093(this.flowDirection);
        class_2680 blockState2 = world.method_8320(blockPos);
        class_3610 fluidState = this.method_15727(world, blockPos, blockState2);
        if (this.method_15738((class_1922)world, fluidPos, blockState, this.flowDirection, blockPos, blockState2, world.method_8316(blockPos), fluidState.method_15772())) {
            this.method_15745((class_1936)world, blockPos, blockState2, this.flowDirection, fluidState);
            if (this.method_15740((class_4538)world, fluidPos) >= 3) {
                this.method_15744(world, fluidPos, state, blockState);
            }
        } else if (state.method_15771() || !this.method_15736((class_1922)world, fluidState.method_15772(), fluidPos, blockState, blockPos, blockState2)) {
            this.method_15744(world, fluidPos, state, blockState);
        }
    }

    protected class_3610 method_15727(class_1937 world, class_2338 pos, class_2680 state) {
        class_2338 blockPos2;
        class_2680 blockState3;
        class_3610 fluidState3;
        int i = 0;
        int j = 0;
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 blockPos = pos.method_10093(direction);
            class_2680 blockState = world.method_8320(blockPos);
            class_3610 fluidState = blockState.method_26227();
            if (!fluidState.method_15772().method_15780((class_3611)this) || !this.method_15732(direction, (class_1922)world, pos, state, blockPos, blockState)) continue;
            if (fluidState.method_15771()) {
                ++j;
            }
            i = Math.max(i, fluidState.method_15761());
        }
        if (this.method_15737(world) && j >= 2) {
            class_2680 blockState2 = world.method_8320(pos.method_10093(this.flowDirection));
            class_3610 fluidState2 = blockState2.method_26227();
            if (blockState2.method_51367() || this.method_15752(fluidState2)) {
                return this.method_15729(false);
            }
        }
        if (!(fluidState3 = (blockState3 = world.method_8320(blockPos2 = pos.method_10093(this.flowDirection.method_10153()))).method_26227()).method_15769() && fluidState3.method_15772().method_15780((class_3611)this) && this.method_15732(this.flowDirection.method_10153(), (class_1922)world, pos, state, blockPos2, blockState3)) {
            return this.method_15728(8, true);
        }
        int k = i - this.method_15739((class_4538)world);
        if (k <= 0) {
            return class_3612.field_15906.method_15785();
        }
        return this.method_15728(k, false);
    }

    protected int method_15742(class_4538 world, class_2338 blockPos, int i, class_2350 direction, class_2680 blockState, class_2338 blockPos2, Short2ObjectMap<Pair<class_2680, class_3610>> short2ObjectMap, Short2BooleanMap short2BooleanMap) {
        int j = 1000;
        for (class_2350 direction2 : class_2350.class_2353.field_11062) {
            int k;
            if (direction2 == direction) continue;
            class_2338 blockPos3 = blockPos.method_10093(direction2);
            short s2 = class_3609.method_15747((class_2338)blockPos2, (class_2338)blockPos3);
            Pair pair = (Pair)short2ObjectMap.computeIfAbsent(s2, s -> {
                class_2680 blockState1 = world.method_8320(blockPos3);
                return Pair.of((Object)blockState1, (Object)blockState1.method_26227());
            });
            class_2680 blockState2 = (class_2680)pair.getFirst();
            class_3610 fluidState = (class_3610)pair.getSecond();
            if (!this.method_15746((class_1922)world, this.method_15750(), blockPos, blockState, direction2, blockPos3, blockState2, fluidState)) continue;
            boolean bl = short2BooleanMap.computeIfAbsent(s2, s -> {
                class_2338 blockPos4 = blockPos3.method_10093(this.flowDirection);
                class_2680 blockState4 = world.method_8320(blockPos4);
                return this.method_15736((class_1922)world, this.method_15750(), blockPos3, blockState2, blockPos4, blockState4);
            });
            if (bl) {
                return i;
            }
            if (i >= this.method_15733(world) || (k = this.method_15742(world, blockPos3, i + 1, direction2.method_10153(), blockState2, blockPos2, short2ObjectMap, short2BooleanMap)) >= j) continue;
            j = k;
        }
        return j;
    }

    public boolean method_15736(class_1922 world, class_3611 fluid, class_2338 pos, class_2680 state, class_2338 fromPos, class_2680 fromState) {
        if (!this.method_15732(this.flowDirection, world, pos, state, fromPos, fromState)) {
            return false;
        }
        if (fromState.method_26227().method_15772().method_15780((class_3611)this)) {
            return true;
        }
        return this.method_15754(world, fromPos, fromState, fluid);
    }

    public int method_15740(class_4538 world, class_2338 pos) {
        int i = 0;
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 blockPos = pos.method_10093(direction);
            class_3610 fluidState = world.method_8316(blockPos);
            if (!this.method_15752(fluidState)) continue;
            ++i;
        }
        return i;
    }

    protected Map<class_2350, class_3610> method_15726(class_1937 world, class_2338 pos, class_2680 state) {
        int i = 1000;
        EnumMap map = Maps.newEnumMap(class_2350.class);
        Short2ObjectOpenHashMap short2ObjectMap = new Short2ObjectOpenHashMap();
        Short2BooleanOpenHashMap short2BooleanMap = new Short2BooleanOpenHashMap();
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            int j;
            class_2338 blockPos = pos.method_10093(direction);
            short s2 = class_3609.method_15747((class_2338)pos, (class_2338)blockPos);
            Pair pair = (Pair)short2ObjectMap.computeIfAbsent(s2, s -> {
                class_2680 blockState = world.method_8320(blockPos);
                return Pair.of((Object)blockState, (Object)blockState.method_26227());
            });
            class_2680 blockState = (class_2680)pair.getFirst();
            class_3610 fluidState = (class_3610)pair.getSecond();
            class_3610 fluidState2 = this.method_15727(world, blockPos, blockState);
            if (!this.method_15746((class_1922)world, fluidState2.method_15772(), pos, state, direction, blockPos, blockState, fluidState)) continue;
            class_2338 blockPos2 = blockPos.method_10093(this.flowDirection);
            boolean bl = short2BooleanMap.computeIfAbsent(s2, s -> {
                class_2680 blockState2 = world.method_8320(blockPos2);
                return this.method_15736((class_1922)world, this.method_15750(), blockPos, blockState, blockPos2, blockState2);
            });
            int n = j = bl ? 0 : this.method_15742((class_4538)world, blockPos, 1, direction.method_10153(), blockState, pos, (Short2ObjectMap<Pair<class_2680, class_3610>>)short2ObjectMap, (Short2BooleanMap)short2BooleanMap);
            if (j < i) {
                map.clear();
            }
            if (j > i) continue;
            map.put(direction, fluidState2);
            i = j;
        }
        return map;
    }

    public static boolean isFluidInDirectionEqual(class_3610 state, class_1922 world, class_2338 pos) {
        class_3611 class_36112 = state.method_15772();
        if (class_36112 instanceof DirectionalFluid) {
            DirectionalFluid directionalFluid = (DirectionalFluid)class_36112;
            return state.method_15772().method_15780(world.method_8316(pos.method_10093(directionalFluid.getFlowDirection())).method_15772());
        }
        return state.method_15772().method_15780(world.method_8316(pos.method_10084()).method_15772());
    }

    public float method_15788(class_3610 state, class_1922 world, class_2338 pos) {
        if (DirectionalFluid.isFluidInDirectionEqual(state, world, pos)) {
            return 1.0f;
        }
        return state.method_20785();
    }

    public class_265 method_17775(class_3610 state, class_1922 world, class_2338 pos) {
        if (state.method_15761() == 9 && DirectionalFluid.isFluidInDirectionEqual(state, world, pos)) {
            return class_259.method_1077();
        }
        return this.field_17587.computeIfAbsent(state, fluidState -> class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)fluidState.method_15763(world, pos), (double)1.0));
    }

    @Environment(value=EnvType.CLIENT)
    public boolean useDefaultRenderer() {
        return true;
    }
}

